/*
 * Decompiled with CFR 0.152.
 */
package net.nova.hexxit_gear.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.nova.hexxit_gear.HexxitGearR;
import net.nova.hexxit_gear.data.BlockStateAndModelProvider;
import net.nova.hexxit_gear.data.DatapackProvider;
import net.nova.hexxit_gear.data.HGItemModelProvider;
import net.nova.hexxit_gear.data.LangProvider;
import net.nova.hexxit_gear.data.loot.HGLootTableProvider;
import net.nova.hexxit_gear.data.recipe.HGRecipeProvider;
import net.nova.hexxit_gear.data.tags.HGBlockTagsProvider;
import net.nova.hexxit_gear.data.tags.HGItemTagsProvider;

@Mod.EventBusSubscriber(modid="hexxit_gear", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        try {
            DataGenerator generator = event.getGenerator();
            PackOutput output = generator.getPackOutput();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            CompletableFuture lookupProvider = event.getLookupProvider();
            generator.addProvider(true, (DataProvider)new LangProvider(output));
            generator.addProvider(true, (DataProvider)new BlockStateAndModelProvider(output, existingFileHelper));
            generator.addProvider(true, (DataProvider)new HGItemModelProvider(output, existingFileHelper));
            HGBlockTagsProvider modBlockTagsProvider = new HGBlockTagsProvider(output, lookupProvider, existingFileHelper);
            generator.addProvider(true, (DataProvider)modBlockTagsProvider);
            generator.addProvider(true, (DataProvider)new HGItemTagsProvider(output, lookupProvider, modBlockTagsProvider, existingFileHelper));
            generator.addProvider(true, (DataProvider)new HGLootTableProvider(output));
            generator.addProvider(true, (DataProvider)new HGRecipeProvider(output));
            generator.addProvider(true, (DataProvider)new DatapackProvider(output, lookupProvider));
        }
        catch (RuntimeException e) {
            HexxitGearR.logger.error("Cosmicore failed to gather data", (Throwable)e);
        }
    }
}

